clear all;
close all;

%File details
    delimiterIn = ' ';
    headerLinesIn = 0;

    if(exist('PathName','var')==0); PathName = ''; end
    
    Tmin = 1.9;
    Tmax = 5.8;

% Open the datafile
    FilterSpec = '.dat';
    DialogTitle = 'Select file with T/R data.';
    [posH_Datafile,PathName] = uigetfile(FilterSpec,DialogTitle,PathName);
    imp_Data = importdata([PathName,posH_Datafile],delimiterIn,headerLinesIn);
   
% Checks to see if datafiles are structures
    if(isstruct(imp_Data)); Data_raw=imp_Data.data;
    else Data_raw = imp_Data; end  
    
    Data(:,1) = Data_raw(:,1);
    Data(:,2) = Data_raw(:,2);
    
% % Split data file into only up sweep
%     n = size(Data_raw,1);
%     j = 1;
%     for i = 1:n-1
%         if Data_raw(i+1,1) > Data_raw(i,1)
%             Data(j,1) = Data_raw(i,1);
%             Data(j,2) = Data_raw(i,2);
%             j = j + 1;
%         else end
%     end


% Average data with the same x value.
    [C,ia,idx] = unique(Data(:,1),'stable');
    val = accumarray(idx,Data(:,2),[],@mean); 
    Data_unique = [C val];
 
% Use an interpolant fit (spline) and calculate results every 10mK.
    T = Data_unique(:,1);
    R = Data_unique(:,2);
    TT = Tmin:0.01:Tmax;
    TT = reshape(TT,[size(TT,2),1]);
    RR = spline(T,R,TT);

% Smooth data.
% Change value/smoothing type, however be will smear out features.
    yy = smooth(TT,RR,0.01,'moving');

% Plot R/T curve, and check for errors in the average/smoothing process.
    figure;
    hold on;
    box on;
    plot(Data(:,1),Data(:,2),TT,yy);
    set(gca,'fontsize',15,'fontname','times');
    set(gcf,'color','w');
    xlabel('H (\mu_{0}T)','fontsize',20,'fontname','times');
    ylabel('Resistance (\Omega)','fontsize',20,'fontname','times');
    
% Calculate derivative.
    dRdT = gradient(yy,TT);

% Fit sc transition  
    Data_sc(:,1) = TT;
    Data_sc(:,2) = dRdT;

    i = 1;
    while(Data_sc(i,1)<Tmax-0.1) 
        i = i + 1; 
    end

%Fit gaussian to find Tc midpoint 
    f = fit(Data_sc(1:i,1),Data_sc(1:i,2),'gauss1')
    coeffvals = coeffvalues(f);
    b1 = coeffvals(2);
    c1 = coeffvals(3);

%Plot dR/dT and fit a guassian        
    figure;
    plot(f,Data_sc(:,1),Data_sc(:,2),'xk');
    set(gca,'fontsize',15,'fontname','times');
    set(gcf,'color','w');
    xlabel('\it T (K)','fontsize',20,'fontname','times');
    ylabel('\it dR/dT (arb. units)','fontsize',20,'fontname','times');
    title('FeSeLF8');
    
%Linear fit through the sc transition
    n = size(TT,1);
    j = 1;
    for i = 1:n
        if TT(i,1) <= (b1+0.5*c1) && TT(i,1) >= (b1-0.5*c1)
            Tcmid(j,1) = TT(i,1);
            Tcmid(j,2) = yy(i,1);
            j = j + 1;
        end
    end
    Tcmid_fit = polyfit(Tcmid(:,1),Tcmid(:,2),1);
    Tcmid_x = Tmin:0.01:Tmax;
    Tcmid_y = polyval(Tcmid_fit,Tcmid_x);
    
%Linear fit through sc region
    n = size(TT,1);
    nr = round((n./10));
    j = 1;
    for i = 1:nr
        Tclow(j,1) = TT(i,1);
        Tclow(j,2) = yy(i,1);
        j = j + 1;
    end
    Tclow_fit = polyfit(Tclow(:,1),Tclow(:,2),1);
    Tclow_x = Tmin:0.01:Tmax;
    Tclow_y = Tcmid_x*0;
    
%Linear fit through normal region
    n = size(TT,1);
    nr = round((n./4));
    j = 1;
    for i = (n-nr):n
        Tchigh(j,1) = TT(i,1);
        Tchigh(j,2) = yy(i,1);
        j = j + 1;
    end
    Tchigh_fit = polyfit(Tchigh(:,1),Tchigh(:,2),1);
    Tchigh_x = Tmin:0.01:Tmax;
    Tchigh_y = polyval(Tchigh_fit,Tchigh_x);
       
%Calculate intercepts
    b0 = InterX([Tclow_x;Tclow_y],[Tcmid_x;Tcmid_y]); 
    b0 = b0(1);
    b2 = InterX([Tcmid_x;Tcmid_y],[Tchigh_x;Tchigh_y]);
    b2 = b2(1);
   
    
%Plot to check linear fits    
    xmin = min(TT); xmax = max(TT);
    ymin = min(yy)-0.5; ymax = max(yy)+0.5;
    figure;
    hold on;
    plot(TT,yy);
    plot(Tcmid_x,Tcmid_y);
    plot(Tclow_x,Tclow_y);
    plot(Tchigh_x,Tchigh_y);
    xlim([xmin xmax]);
    ylim([ymin ymax]);
    set(gca,'fontsize',15,'fontname','times');
    set(gcf,'color','w');
    xlabel('\it T (K)','fontsize',20,'fontname','times');
    ylabel('\it R (\Omega)','fontsize',20,'fontname','times');
    %title('FeSeLF8');
    box on;
    
    b0
    b1
    b2
          

            

    
    


